unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ExtCtrls, StdCtrls;

type
  TBaanForm = class(TForm)
    MainMenu1: TMainMenu;
    Bestand1: TMenuItem;
    Sluiten1: TMenuItem;
    Afsluiten1: TMenuItem;
    Openen1: TMenuItem;
    Toelichting1: TMenuItem;
    PaintBox: TPaintBox;
    Label1: TLabel;
    Label2: TLabel;
    xEdit: TEdit;
    yEdit: TEdit;
    TekenButton: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    coordLabel: TLabel;
    Label7: TLabel;
    IterLabel: TLabel;
    aantalIterLabel: TLabel;
    muisCoordLabel: TLabel;
    invulPanel: TPanel;
    cLabel: TLabel;
    aLabel: TLabel;
    bLabel: TLabel;
    aEdit: TEdit;
    bEdit: TEdit;
    Label5: TLabel;
    actCoordLabel: TLabel;
    ResetButton: TButton;
    ResetABButton: TButton;
    Help1: TMenuItem;
    Help2: TMenuItem;
    About1: TMenuItem;
    Label8: TLabel;
    Derand1: TMenuItem;
    Label9: TLabel;
    coordComboBox: TComboBox;
    Label10: TLabel;
    betaEdit: TEdit;
    Label11: TLabel;
    Label12: TLabel;
    procedure Sluiten1Click(Sender: TObject);
    procedure Afsluiten1Click(Sender: TObject);
    procedure Toelichting1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PaintBoxPaint(Sender: TObject);
    procedure TekenButtonClick(Sender: TObject);
    procedure PaintBoxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBoxMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure xEditKeyPress(Sender: TObject; var Key: Char);
    procedure yEditKeyPress(Sender: TObject; var Key: Char);
    procedure aEditKeyPress(Sender: TObject; var Key: Char);
    procedure bEditKeyPress(Sender: TObject; var Key: Char);
    procedure ResetButtonClick(Sender: TObject);
    procedure ResetABButtonClick(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Derand1Click(Sender: TObject);
    procedure coordComboBoxSelect(Sender: TObject);
    procedure betaEditKeyPress(Sender: TObject; var Key: Char);
    private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  BaanForm: TBaanForm;
  grens, aantal: Integer; // grens: bepaalt uitersten schaalverdeling assen
                          // aantal: aantal iteraties
  x,y: double; //hulpvariabelen bij tekenen beginsituatie
  a,b: double; //waarden uit c=a+bi
  beta: double; //waarde van het argument van punt op eenheidscirkel
  muisPos: TPoint; //punt waar de muis is
  xcoord, ycoord: double; //coordinaten van te tekenen punt
  xcoordRij: array[0..50] of double; //opslag xcoord rij punten voor tekenen na herschalen
  ycoordRij: array[0..50] of double; //opslag ycoord rij punten

implementation

uses Unit2, Unit4, Unit1, RandUnit;

{$R *.dfm}

procedure TBaanForm.Sluiten1Click(Sender: TObject);
begin
     BaanForm.Close;
end;

procedure TBaanForm.Afsluiten1Click(Sender: TObject);
begin
     if MessageDlg('Weet U zeker dat U wilt afsluiten?',
        mtConfirmation, [mbYes, mbCancel],0)=mrYes then
        Application.Terminate;
end;

procedure TBaanForm.Toelichting1Click(Sender: TObject);
begin
     BaanForm.Close;
     ToelichtingForm.Show;
end;


procedure TBaanForm.FormCreate(Sender: TObject);
begin
     grens:=2; //beginwaarde grenzen assen
     aantal:=0; //beginwaarde aantal iteraties
     a:=0; //beginwaarden a en b
     b:=0;
     
end;


function pixx (x: real) :integer; //zet x-coordinaat om in pixelcoord van PaintBox
begin
     result:=round(x*300/grens +300);
end;

function invpixx (x: integer) : real; //zet pixelcoord van PaintBox om in x-coordinaat
begin
     result:=(x-300)*grens/300;
end;



function pixy (y: real) :integer; //zet y-coordinaat om in pixelcoord van PaintBox
begin
     result:=round((grens-y)/grens*300);
end;

function invpixy (y: integer) : real; //zet pixelcoord van PaintBox om in y-coordinaat
begin
     result:=grens-y*grens/300;
end;

function funcx(x,y: real) :real; //berekent reele deel f(z)=z^2+c
begin
     result:=x*x-y*y+a;
end;

function funcy(x,y: real) :real; //berekent imaginaire deel f(z)=z^2+c
begin
     result:=2*x*y+b;
end;

procedure cirkelTekenen;
var
   i: integer;
begin
     with BaanForm.PaintBox.Canvas do
     begin
          MoveTo(pixx(-1),pixy(0));
          Pen.Color:=clYellow;
          for i:=-150 to 150 do   //bovenste helft
              begin
                   x:=i/150;
                   y:=sqrt(1-x*x);
                   LineTo(pixx(x),pixy(y));
              end;
          MoveTo(pixx(-1),pixy(0));
          for i:=-150 to 150 do   //onderste helft
              begin
                   x:=i/150;
                   y:=-sqrt(1-x*x);
                   LineTo(pixx(x),pixy(y));
              end;
     end;
end;

procedure TBaanForm.PaintBoxPaint(Sender: TObject);
var
   i :integer;
   begin
      with PaintBox.Canvas do
     begin
          Pen.Color:= clBlack; //rand tekenen
          MoveTo(0, 0);
          LineTo(0, 600);
          LineTo(600, 600);
          LineTo(600, 0);
          LineTo(0, 0);
          Pen.Color:=clBlue; //assen tekenen
          MoveTo(0, 300);
          LineTo(600, 300);
          MoveTo(300, 0);
          LineTo(300, 600);
          Pen.Color:=clGreen; //maatstrepen assenverdeling
          for i:=0 to 7 do //horizontaal
              begin
                  MoveTo(0+75*i,303);
                  LineTo(0+75*i,297);
              end;
          for i:=0 to 7 do //vertikaal
              begin
                  MoveTo(303,0+75*i);
                  LineTo(297,0+75*i);
              end;
          //schaalverdeling vermelden
          TextOut(5, 305, IntToStr(-grens)); //hor as
          TextOut(140, 305, IntToStr(-grens div 2)); //gehele deling!!**********
          TextOut(445, 305, IntToStr(grens div 2));  // eventueel gewone deling maken***
          TextOut(585, 305, IntToStr(grens));
          TextOut(285, 10, IntToStr(grens)); // vert as
          TextOut(285, 145, IntToStr(grens div 2));
          TextOut(285, 445, IntToStr(-grens div 2));
          TextOut(285, 585, IntToStr(-grens));
     end;
     cirkelTekenen;

     end;

procedure tekenPunt (x, y: double; kleur: TColor); //tekenen kruisje als punt
begin
     with BaanForm.PaintBox do
              begin
                   Canvas.Pixels[pixx(x),pixy(y)]:=kleur; //tekenen centraal punt
                   Canvas.Pixels[pixx(x)-1,pixy(y)]:=kleur; //tekenen
                   Canvas.Pixels[pixx(x)+1,pixy(y)]:=kleur; //tekenen
                   Canvas.Pixels[pixx(x),pixy(y)-1]:=kleur; //tekenen
                   Canvas.Pixels[pixx(x),pixy(y)+1]:=kleur; //tekenen
              end;
end;

procedure TBaanForm.TekenButtonClick(Sender: TObject);
var
xtijd, ytijd: real;// 'tussenwaarden' voor coordinaten tijdens berekening
i: integer;
begin

     aantalIterLabel.Caption:=IntToStr(aantal)+' ';// toevoeging spatie vanwege
                                                 // afkappen label op scherm
     if (aantal=0)  // bij aanvang tekenen baan
     then
         begin
              aEdit.Enabled:=false;
              bEdit.Enabled:=false;
              xEdit.Enabled:=false;
              yEdit.Enabled:=false;
              ResetABButton.Enabled:=false;
              coordComboBox.Enabled:=false;
              xEdit.Text:='';
              yEdit.Text:='';
              a:=StrToFloat(aEdit.Text);
              b:=StrToFloat(bEdit.Text);
                // coord beginpunt afdrukken:
              coordLabel.Caption:='('+FloatToStr(xcoord)+', '+FloatToStr(ycoord)+') ';
              tekenPunt(xcoord,ycoord, clRed);// beginpunt tekenen
         end
     else
            begin
                 if (aantal=1) then PaintBox.Canvas.MoveTo(pixx(xcoord), pixy(ycoord));
                 xtijd:=funcx(xcoord,ycoord); // nieuwe coord uitrekenen
                 ytijd:=funcy(xcoord,ycoord); // bewaren in tijdelijke var
                 xcoord:=xtijd; // nieuwe coordinaten
                 ycoord:=ytijd;
                 // controle op tekenen buiten de actuele grenzen vd paintBox
                 if (abs(xcoord)>=grens) or (abs(ycoord)>=grens) then
                 begin
                      if (grens=2) then grens:=10
                      else repeat grens:=grens*10
                           until (abs(xcoord)<grens) and (abs(ycoord)<grens) or (grens >100000);
                      if (grens>1000000) then grens:=1000000;
                      if (abs(xcoord)>=grens) or (abs(ycoord)>=grens) then TekenButton.Enabled:=false;
                      PaintBox.Repaint;
                      with PaintBox.Canvas do
                      begin
                           Pen.Color:=clBlack;
                           MoveTo(pixx(xcoordRij[0]), pixy(ycoordRij[0]));
                           tekenPunt(xcoordRij[0], ycoordRij[0], clBlue);
                           for i:=0 to aantal-1 do
                               begin
                                    LineTo(pixx(xcoordRij[i]), pixy(ycoordRij[i]));
                                    tekenPunt(xcoordRij[i], ycoordRij[i],clBlue);
                               end;
                      end;
                 end;
                 xcoordRij[aantal]:=xcoord; // coord opslaan
                 ycoordRij[aantal]:=ycoord;

                 with PaintBox.Canvas do
                 begin
                      tekenPunt(xcoordRij[aantal-1],ycoordRij[aantal-1], clBlue);
                      Pen.Color:=clBlack;
                      LineTo(pixx(xcoord), pixy(ycoord));
                 end;
                 tekenPunt(xcoord, ycoord, clRed);

            end;

     actCoordLabel.Caption:='('+FloatToStr(xcoord)+', '+FloatToStr(ycoord)+') ';
     aantal:=aantal+1; // aantal iteraties ophogen
end;




procedure TBaanForm.PaintBoxMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
   xmuis, ymuis: String;

begin
   //left:=RandForm.Left;
   //top:=RandForm.Top;
   muisPos:=Mouse.CursorPos; //muiscoordinaten op hele scherm
   muisPos:=PaintBox.ScreenToClient(muisPos);  //PaintBox(=client)-coordinaten
   begin
        muisCoordLabel.Left:=muisPos.X+25; //bewegend Label positioneren, rechtsonder muis
        muisCoordLabel.Top:=muisPos.Y+10;
        xmuis:=FormatFloat('#.00',invpixx(muisPos.x)); //afronden op 2 decimalen op scherm
        ymuis:=FormatFloat('#.00',invpixy(muisPos.y));
        xEdit.Text:=xmuis; //coord in venster
        yEdit.Text:=ymuis;
        //meebewegend label alleen zichtbaar maken als cursor binnen kader :
        if (muisPos.x>=600) or(muisPos.y>=600) or (muisPos.x=0) or (muisPos.y=0)then
           begin
                muisCoordLabel.Left:=400;
                muisCoordLabel.Top:=0;
                muisCoordLabel.Caption:='';
           end
        else
           muisCoordLabel.Caption:='('+xmuis+', '+ymuis+')';//(muis-)coord laten zien
     end;


end;

procedure TBaanForm.PaintBoxMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if (aantal=0) then
     begin
          muisPos:=Mouse.CursorPos; //muiscoordinaten op hele scherm
          muisPos:=PaintBox.ScreenToClient(muisPos);  //PaintBox(=client)-coordinaten
          xcoord:=invpixx(muisPos.x);
          ycoord:=invpixy(muisPos.y);
          PaintBox.Canvas.Pixels[pixx(xcoord),pixy(ycoord)]:=clBlack; //tekenen
          coordLabel.Caption:='('+FloatToStr(xcoord)+', '+FloatToStr(ycoord)+') ';
          xcoordRij[0]:=xcoord; // (voorlopig) vastleggen coordinaten beginpunt
          ycoordRij[0]:=ycoord;
     end;
end;

procedure TBaanForm.xEditKeyPress(Sender: TObject; var Key: Char);
begin
     if key=#13 then
        begin
             yEdit.SetFocus;
             try
                xcoord:=StrToFloat(xEdit.Text);
             except
                on EConvertError do
                   begin
                        ShowMessage('Vul een geldig getal uit [-2, 2] in!');
                        xEdit.SetFocus;
                   end;
             end;
             if (xcoord<-2) or (xcoord>2) then
             begin
                  xcoord:=0;
                  ShowMessage('Vul een geldig getal uit [-2, 2] in!');
             end;
             xcoordRij[0]:=xcoord;
             coordLabel.Caption:='('+FloatToStr(xcoord)+', '+FloatToStr(ycoord)+')';
             
        end;
end;

procedure TBaanForm.yEditKeyPress(Sender: TObject; var Key: Char);
begin
     if key=#13 then
        begin
             TekenButton.SetFocus;
             try
                ycoord:=StrToFloat(yEdit.Text);
             except
                on EConvertError do
                   begin
                        ShowMessage('Vul een geldig getal uit [-2, 2] in!');
                        yEdit.SetFocus;
                   end;
             end;
             if (ycoord<-2) or (ycoord>2) then
             begin
                  ycoord:=0;
                  ShowMessage('Vul een geldig getal uit [-2, 2] in!');
             end;
             ycoordRij[0]:=ycoord;
             coordLabel.Caption:='('+FloatToStr(xcoord)+', '+FloatToStr(ycoord)+') ';
             TekenButton.SetFocus;
        end;
end;

procedure TBaanForm.aEditKeyPress(Sender: TObject; var Key: Char);
begin
     if key=#13 then
        begin
             bEdit.SetFocus;
             try
                a:=StrToFloat(aEdit.Text);
             except
                on EConvertError do
                   begin
                        ShowMessage('Vul een geldig getal in!');
                        aEdit.SetFocus;
                   end;
             end;
        end;
end;

procedure TBaanForm.bEditKeyPress(Sender: TObject; var Key: Char);
begin
     if key=#13 then
        begin
             xEdit.SetFocus;
             try
                b:=StrToFloat(bEdit.Text);
             except
                on EConvertError do
                   begin
                        ShowMessage('Vul een geldig getal in!');
                        bEdit.SetFocus;
                   end;
             end;
        end;
end;

procedure TBaanForm.ResetButtonClick(Sender: TObject);
var
   i: integer;
begin
     aEdit.Enabled:=true;
     bEdit.Enabled:=true;
     xEdit.Enabled:=true;
     yEdit.Enabled:=true;
     ResetABButton.Enabled:=true;
     TekenButton.Enabled:=true;
     coordComboBox.Enabled:=true;
     grens:=2;
     for i:=1 to aantal do
         begin
              xcoordRij[i]:=0;
              ycoordRij[i]:=0;
         end;
     xcoord:=0;
     ycoord:=0;
     aantal:=0;
     coordLabel.Caption:='--';
     aantalIterLabel.Caption:='0 ';
     actCoordLabel.Caption:='--';
     betaEdit.Text:='';
     xEdit.Text:='';
     yEdit.Text:='';
     coordComboBox.ItemIndex:=0;
     PaintBox.Repaint;
end;

procedure TBaanForm.ResetABButtonClick(Sender: TObject);
begin
     aEdit.Text:='0';
     bEdit.Text:='0';
     aEdit.SetFocus;
end;

procedure TBaanForm.Help2Click(Sender: TObject);
begin
     BaanForm.Close;
     HelpForm.Show;
end;

procedure TBaanForm.About1Click(Sender: TObject);
begin
     AboutBox.Show;
end;

procedure TBaanForm.Derand1Click(Sender: TObject);
begin
     BaanForm.Close;
     RandForm.Show;
end;

procedure TBaanForm.coordComboBoxSelect(Sender: TObject);
begin
     case coordComboBox.ItemIndex of
     1:  begin xcoord:= 0.98480775301220805936674302458952;  // 10
               ycoord:= 0.17364817766693034885171662676931; end;
     2:  begin xcoord:= 0.86602540378443864676372317075294;  // 30
               ycoord:= 0.5 end;
     3:  begin xcoord:= 0.70710678118654752440084436210485;  // 45
               ycoord:= 0.70710678118654752440084436210485;  end;
     4:  begin xcoord:= 0.95630475596303548133865081661842;  // 17
               ycoord:= 0.29237170472273672809746869537714;  end;
     5:  begin xcoord:= 0.99984769515639123915701155881391;  //  1
               ycoord:= 0.017452406437283512819418978516316; end;
     6:  begin xcoord:= 0.99969539804519463451053618137335;  // V2
               ycoord:= 0.024680176807710671848752406186811; end;
     end;
     xEdit.Text:=FloatToStr(xcoord);
     yEdit.Text:=FloatToStr(ycoord);
     xcoordRij[0]:= xcoord;
     ycoordRij[0]:= ycoord;
     coordLabel.Caption:='('+FloatToStr(xcoord)+', '+FloatToStr(ycoord)+') ';
     TekenButton.SetFocus;
end;

procedure TBaanForm.betaEditKeyPress(Sender: TObject; var Key: Char);

begin
     if key=#13 then
        begin
             try
                beta:=StrToFloat(betaEdit.Text);
             except
                on EConvertError do
                   begin
                        ShowMessage('Vul een getal in tussen -360 en +360!');
                        betaEdit.SetFocus;
                   end;
             end;
        
             xcoord := cos(beta * pi/180);
             ycoord := sin(beta * pi/180);
             xcoordRij[0]:= xcoord;
             ycoordRij[0]:= ycoord;
             xEdit.Text := FloatToStr(xcoord);
             yEdit.Text := FloatToStr(ycoord);
             PaintBox.Canvas.Pixels[pixx(xcoord),pixy(ycoord)]:=clBlack; //tekenen
             coordLabel.Caption:='('+FloatToStr(xcoord)+', '+FloatToStr(ycoord)+') ';
             TekenButton.SetFocus;
        end;
end;

end.


